﻿#include  "StdAfx.h"

#include  <szGetText.hpp>
#include  <cstdio>
#include  <tchar.h>
#include  <boost/tokenizer.hpp>

SZ_AN_BEG

typedef std::map<szstring, szstring> catalog_type;

szstring     textCatalogPath;
catalog_type textCatalog;

SZ_AN_END

using namespace std;
using namespace boost;

SZ_NS_BEG(szpp)

SZ_SPEC
const szstring &GetCurrentTextCatalogPath()
{
  return textCatalogPath;
}

SZ_SPEC
void SetCurrentTextCatalogPath(const szstring &path)
{
  FILE *fp = 0;
  
  // ランゲージファイルは
  //   "english text here"="これは日本語のテキストです"
  // というフォーマットで書かれた UTF-8 のテキストとする。
  // BOM はあってもなくても読み込める。
  // SevenZip++ およびアプリのソースツリーでは、単純に結合できるように、BOM は付けていない。

  _tfopen_s(&fp, path.c_str(), SZL("r, ccs=UTF-8"));
  if (fp != 0)
  {
    typedef escaped_list_separator<szchar> sep_type;
    typedef tokenizer< sep_type, szstring::const_iterator, szstring > tok_type;

    sep_type  sep(SZL("\\"), SZL("="), SZL("\""));
    szchar    buffer[1024];

    textCatalog.clear();

    while (_fgetts(buffer, 1024, fp) != 0)
    {
      const szstring line(buffer);
      tok_type tok(line, sep);

      int argCount = 0;
      szstring key, value;
      for (tok_type::const_iterator it = tok.begin(); it != tok.end(); ++it)
      {
        szstring tok(*it);

        if (tok.size() > 1 && *tok.rbegin() == SZL('\n'))
          tok = tok.substr(0, tok.size() - 1);

        if (++argCount == 1)
          key = tok;
        else if (argCount == 2)
          value = tok;
        else
          break;
      }

      if (!key.empty() && !value.empty())
        textCatalog[key] = value;
    }

    textCatalogPath = path;

    fclose(fp);
  }
}

SZ_SPEC
const szchar *GetText(const szchar *key)
{
  catalog_type::const_iterator it = textCatalog.find(szstring(key));

  if (it != textCatalog.end() && !it->second.empty())
    return it->second.c_str();

  return key;
}

SZ_NS_END(szpp)
